// **************
// * AXISEO.COM *
// **************

#define SERIAL_BAUDRATE 9600
#define NB_BYTES_MSG 7            // Exemple : 65 00 01 01 FF FF FF (bouton "allumer led") ou bien 65 00 03 01 FF FF FF (bouton "éteindre led")
#define NUM_BROCHE_LED 11         // Indique quelle broche de l'arduino sera utilisée pour y brancher la LED à piloter

unsigned char incomingByte;       // variable de stockage des données entrantes (1 octet à la fois)
unsigned char msg[NB_BYTES_MSG];  // variable qui contiendra le message entier
bool msgEnCours = false;          // indique si oui ou non il y a un message en cours de réception
int idx = 0;                      // index

void setup() {
  pinMode(NUM_BROCHE_LED, OUTPUT);      // définition de la broche n°NUM_BROCHE_LED en sortie
  digitalWrite(NUM_BROCHE_LED, LOW);    // extinction de la led
  Serial3.begin(SERIAL_BAUDRATE);       // Vitesse de transmission série (vers ECRAN LCD)
  Serial.begin(SERIAL_BAUDRATE);        // Vitesse de transmission série (vers PC)
  delay(10);                            // Attente (en milli-secondes)
  Serial3.flush();                      // Vide le buffer de réception de données du port série (côté écran tactile)
}

void loop() {

  if(Serial3.available() > 0) {              // Test si quelque chose en attente de lecture sur le port série 3 (côté écran LCD)
    
    incomingByte = (char)Serial3.read();     // Lit 1 octet de ce qu'il y a en attente

    // Affichage de l'octet lu sur le port série de l'ECRAN pour l'afficher sur le port série du PC
    Serial.print("Octet reçu (HEX) = ");
    Serial.println(incomingByte, HEX);

    // Test si c'est le début d'une chaine (commence par 65)
    if(incomingByte == 0x65) {
      msg[0] = 0x65;
      msgEnCours = true;       
      idx = 1;
    }
    else
    {
      // Si c'est la suite, on enregistre
      if(msgEnCours == true) {
        msg[idx] = incomingByte;
        idx++;
      }
  
      // On regarde si on est au bout du message ou pas
      if(idx == NB_BYTES_MSG) {
        afficheResultat();
        msgEnCours = false;
        idx = 0;
      }    
    }
  }
}

void afficheResultat() {
  // Affichage
  Serial.print("Message reçu (HEX) : ");
  Serial.print(msg[0], HEX);    
  Serial.print(":");
  Serial.print(msg[1], HEX);
  Serial.print(":");
  Serial.print(msg[2], HEX);
  Serial.print(":");
  Serial.print(msg[3], HEX);
  Serial.print(":");
  Serial.print(msg[4], HEX);
  Serial.print(":");
  Serial.print(msg[5], HEX);
  Serial.print(":");
  Serial.println(msg[6], HEX);

  // Test si bouton 1 appuyé
  if(msg[0]==0x65 && msg[1]==0x00 && msg[2] == 0x01) {    // On regarde si le message commence par 65 00 01 (bouton "ALLUMER LED")
    digitalWrite(NUM_BROCHE_LED, HIGH);                   // si c'est ça, on allume la LED connectée à l'arduino
    Serial.println("Allumage de la LED !");
    Serial.println("----------------------------------------");
  }

  // Test si bouton 2 appuyé
  if(msg[0]==0x65 && msg[1]==0x00 && msg[2] == 0x03) {    // On regarde si le message commence par 65 00 03 (bouton "ETEINDRE LED")
    digitalWrite(NUM_BROCHE_LED, LOW);                    // si c'est ça, on éteint la LED connectée à l'arduino
    Serial.println("Extinction de la LED.");
    Serial.println("----------------------------------------");
  }
}
